/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionContext;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionType;
import com.stevekung.fishofthieves.registry.FOTSpawnConditions;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;

public record MatchBiomeCondition(HolderSet<Biome> biomes) implements SpawnCondition
{
    public static final MapCodec<MatchBiomeCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).fieldOf("biomes").forGetter(MatchBiomeCondition::biomes)).apply((Applicative)instance, MatchBiomeCondition::new));

    @Override
    public SpawnConditionType getType() {
        return FOTSpawnConditions.MATCH_BIOME;
    }

    @Override
    public boolean test(SpawnConditionContext context) {
        return this.biomes.contains(context.level().getBiome(context.blockPos()));
    }

    public static SpawnCondition.Builder biomes(HolderSet<Biome> biomes) {
        return () -> new MatchBiomeCondition(biomes);
    }
}

